#!/bin/bash

# GNU MediaGoblin -- federated, autonomous media hosting
# Copyright (C) 2011 Free Software Foundation, Inc
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Usage: build_docs.sh <path-to-git-repo> <target-dir> [<rev-ish>]

# if we encounter errors, bail out
set -o errexit

# FIXME - need to convert these to absolute paths

# check arguments
# 
REPO=`pwd`/$1
TARGET=`pwd`/$2
REVISH=$3

if [[ -z "$REPO" || -z "$TARGET" ]]
then
    echo "Usage: build_docs.sh <path-to-mediagoblin-repo> <target-dir> [<rev-ish>]"
    exit 1;
fi

if [[ -z "$REVISH" ]]
then
    REVISH=master
fi

echo ">>> Testing commands...."

# check commands
# 
GIT_CMD=$(which git)
if [[ -z $GIT_CMD ]]
then
    echo "Hrmm: I can't find the git command."
    echo "Is git installed?  Is git on your PATH?"
    exit 1;
fi

SPHINX_CMD=$(which sphinx-build)
if [[ -z $SPHINX_CMD ]]
then
    echo "Hrmm: I can't find the sphinx-build command."
    echo "Is Sphinx installed?  Is sphinx-build on your PATH?"
    exit 1;
fi

echo "Woot: Commands tested.  OK"

echo ">>> Fiddling with the repository...."
# create the directory and clone the repository if it doesn't exist
# 
if [[ -d "$REPO" ]]
then
    echo "Woot: $REPO already created."
else
    echo ">>> Creating $REPO...."
    mkdir -p $REPO
    cd $REPO
    "$GIT_CMD" clone git://gitorious.org/mediagoblin/mediagoblin.git mediagoblin
    echo "Woot: $REPO created."
    echo "Note: Use $REPO/mediagoblin for <path-to-mediagoblin-repo> next time."
fi

cd $REPO/mediagoblin

# update the repository
# 
echo ">>> Checking out $REVISH...."
"$GIT_CMD" checkout "$REVISH"
if [[ $? -ne 0 ]]
then
    echo "Hrmm: revish $REVISH does not exist."
    exit 1;
fi

echo ">>> Pulling new changes...."
echo "$GIT_CMD pull -t origin $REVISH"
"$GIT_CMD" pull -t origin $REVISH

if [[ $? -ne 0 ]]
then
    echo "Hrmm: Couldn't pull $REVISH."
    exit 1;
fi

echo ">>> Building the docs...."
cd docs/
make clean
make html

if [[ -d "$TARGET" ]]
then
    echo "Woot: $TARGET exists."
else
    echo "Woot: Creating $TARGET...."
    mkdir -p "$TARGET"
fi

echo ">>> Copying all the files over to $TARGET...."
cp -r _build/html/* $TARGET

echo "Woot: Done!"
