import pytest

from mediagoblin.tools import pagination

#the next 30 lines for the db cursor handle
from sqlalchemy import Column,Integer
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import relationship
from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker

Base=declarative_base()

class Example(Base):
    __tablename__="example"
    id = Column(Integer,primary_key=True)
    testVar = Column(Integer,nullable=False)

engine = create_engine('sqlite:///sqlalchemyExample.db')
Base.metadata.create_all(engine)

DBSession = sessionmaker(bind=engine)
session = DBSession()

obj1 = Example(testVar=1)
obj2 = Example(testVar=2)
obj3 = Example(testVar=3)
obj4 = Example(testVar=4)
obj5 = Example(testVar=5)
session.add(obj1)
session.add(obj2)
session.add(obj3)
session.add(obj4)
session.add(obj5)
session.commit()
#all this just for one db cursor handle :O


class TestPagination:
    cur = session.query(Example)
    paginator = pagination.Pagination(page=3,cursor=cur,per_page=3)
    def test_get_page_url_explicit(self):
        base_url = "www.google.com/"
        get_params = {'query1':'hello','query2':'goodbye'}
        page_no = 4
        assert self.paginator.get_page_url_explicit(base_url, get_params, page_no) == "www.google.com/?query2=goodbye&query1=hello&page=4"

    def test_properties(self):
        assert self.paginator.total_count == 5
        assert self.paginator.pages == 2


session.expunge_all()
session.commit()
session.close()
Base.metadata.drop_all(engine)
